/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractPenetratingProjectile;
import dev.toma.gunsrpg.common.entity.projectile.PenetrationData;
import dev.toma.gunsrpg.util.properties.Properties;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Bullet
extends AbstractPenetratingProjectile {
    public Bullet(EntityType<? extends Bullet> type, World world) {
        super((EntityType<? extends AbstractPenetratingProjectile>)type, world);
    }

    public Bullet(EntityType<? extends Bullet> type, World world, LivingEntity owner) {
        super((EntityType<? extends AbstractPenetratingProjectile>)type, world, owner);
    }

    @Override
    public void preTick() {
    }

    @Override
    public void postTick() {
        this.applyGravity(0.05f);
    }

    @Override
    public boolean func_70112_a(double distance) {
        return this.propertyContext.hasProperty(Properties.TRACER);
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos = result.func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (this.canPenetrateGlass() && state.func_185904_a() == Material.field_151592_s) {
                this.field_70170_p.func_175655_b(pos, false);
                Vector3d projectilePos = this.func_213303_ch();
                this.checkForCollisions(projectilePos, projectilePos.func_178787_e(this.func_213322_ci()));
                return;
            }
            Vector3d vec = result.func_216347_e();
            Vector3i normal = result.func_216354_b().func_176730_m();
            float dirX = (float)normal.func_177958_n() / 5.0f;
            float dirY = (float)normal.func_177958_n() / 5.0f;
            float dirZ = (float)normal.func_177958_n() / 5.0f;
            SoundType type = state.func_215695_r();
            this.field_70170_p.func_184148_a(null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, type.func_185845_c(), SoundCategory.MASTER, type.func_185843_a(), type.func_185847_b());
            SSpawnParticlePacket packet = new SSpawnParticlePacket((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), true, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, dirX, dirY, dirZ, 0.01f, 3);
            ((ServerWorld)this.field_70170_p).func_217369_A().forEach(player -> player.field_71135_a.func_147359_a((IPacket)packet));
            state.func_215690_a(this.field_70170_p, state, result, (ProjectileEntity)this);
            this.func_70106_y();
        }
    }

    @Override
    protected void handleEntityCollision(EntityRayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = result.func_216348_a();
            this.propertyContext.setProperty(Properties.IS_HEADSHOT, this.isHeadshot(entity));
            this.hurtTarget(entity, this.func_234616_v_());
            entity.field_70172_ad = 0;
            PenetrationData penetrationData = this.getProperty(Properties.PENETRATION);
            if (penetrationData == null || penetrationData.getLastHit() != null) {
                this.func_70106_y();
            }
        }
    }

    protected boolean canPenetrateGlass() {
        return true;
    }

    protected boolean isHeadshot(Entity entity) {
        if (!this.canHeadshotEntity(entity)) {
            return false;
        }
        Vector3d vec1 = this.func_213303_ch();
        Vector3d vec2 = vec1.func_178787_e(this.func_213322_ci());
        AxisAlignedBB hitbox = entity.func_174813_aQ();
        return hitbox.func_216365_b(vec1, vec2).map(out -> out.field_72448_b >= entity.func_226280_cw_() - 0.25).orElse(false);
    }
}

